package fr.ensisa.lob.supercallrecorder;

import android.provider.BaseColumns;
import android.util.Base64;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

/**
 * Created by Raphaël on 04/10/2016.
 */
public class Record {


    private long id;
    private String contactName;
    private boolean incoming;
    private String date;
    private String fileName;
    private String salt;


    public String generateSalt() {
        SecureRandom random = new SecureRandom();
        byte bytes[] = new byte[20];
        random.nextBytes(bytes);
        return android.util.Base64.encodeToString(bytes, Base64.DEFAULT);
    }


    public Record(String fileName, String date, String incoming, String contactName) {
        this.id = 0;
        this.salt = generateSalt();
        this.fileName = fileName;
        this.date = date;
        this.incoming = incoming.equals("1");
        this.contactName = contactName;
    }
    public Record(String fileName, String date, String incoming, String contactName,String salt) {
        this.id = 0;
        this.salt = salt;
        this.fileName = fileName;
        this.date = date;
        this.incoming = incoming.equals("1");
        this.contactName = contactName;
    }

    public Record(String fileName, Date date, boolean incoming, String contactName) {
        this.id = 0;
        this.salt = generateSalt();
        this.fileName = fileName;
        this.date = date.toString();
        this.incoming = incoming;
        this.contactName = contactName;
    }
    public Record(long id, String salt, String fileName, Date date, boolean incoming, String contactName) {
        this.id = id;
        this.salt = salt;
        this.fileName = fileName;
        this.date = date.toString();
        this.incoming = incoming;
        this.contactName = contactName;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public boolean isIncoming() {
        return incoming;
    }

    public void setIncoming(boolean incoming) {
        this.incoming = incoming;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Override
    public String toString() {
        return "Record{" +
                "id=" + id +
                ", contactName='" + contactName + '\'' +
                ", incoming=" + incoming +
                ", date='" + date + '\'' +
                ", fileName='" + fileName + '\'' +
                ", salt='" + salt + '\'' +
                '}';
    }
}
