package fr.ensisa.lob.supercallrecorder;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;

/**
 * Created by Raphaël on 04/10/2016.
 */

public class RecordDbHelper  extends SQLiteOpenHelper {
    // If you change the database schema, you must increment the database version.
    public static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "Record.db";

    private static final String TEXT_TYPE = " TEXT";
    private static final String BOOLEAN_TYPE = " INTEGER";
    private static final String COMMA_SEP = ",";
    private static final String SQL_CREATE_ENTRIES =
            "CREATE TABLE " + RecordEntry.TABLE_NAME + " (" +
                    RecordEntry._ID + " INTEGER PRIMARY KEY," +
                    RecordEntry.COLUMN_NAME_CONTACTNAME + TEXT_TYPE + COMMA_SEP +
                    RecordEntry.COLUMN_NAME_INCOMING + BOOLEAN_TYPE + COMMA_SEP +
                    RecordEntry.COLUMN_NAME_DATE + TEXT_TYPE + COMMA_SEP +
                    RecordEntry.COLUMN_NAME_FILENAME + TEXT_TYPE + COMMA_SEP +
                    RecordEntry.COLUMN_NAME_SALT + TEXT_TYPE + " )";

    private static final String SQL_DELETE_ENTRIES =
            "DROP TABLE IF EXISTS " + RecordEntry.TABLE_NAME;

    public static class RecordEntry implements BaseColumns {
        public static final String TABLE_NAME = "Record";
        public static final String COLUMN_NAME_CONTACTNAME = "contactName";
        public static final String COLUMN_NAME_INCOMING = "incoming";
        public static final String COLUMN_NAME_DATE = "callDate";
        public static final String COLUMN_NAME_FILENAME = "fileName";
        public static final String COLUMN_NAME_SALT = "salt";
    }

    public RecordDbHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SQL_CREATE_ENTRIES);
    }
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // This database is only a cache for online data, so its upgrade policy is
        // to simply to discard the data and start over
        db.execSQL(SQL_DELETE_ENTRIES);
        onCreate(db);
    }
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        onUpgrade(db, oldVersion, newVersion);
    }
}